﻿Imports System.IO 'for FileStream class ما يسمى بتدفق الملف
Imports System.Drawing.Printing
Public Class Form1

    Private PrintPageSettings As New PageSettings
    Private StringToPrint As String
    Private PrintFont As New Font("Arial", 10)

    Private Sub btnOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnOpen.Click
        Dim FilePath As String
        'عرض نافذة حوار للبحث عن ملف نصي
        OpenFileDialog1.Filter = "Text files (*.txt)|*.txt"
        OpenFileDialog1.ShowDialog()
        'إذا لم يختر المستخدم "إلغاء الأمر", قم بتحميل مسار الملف
        If OpenFileDialog1.FileName <> "" Then
            FilePath = OpenFileDialog1.FileName
            Try
                'قم بقراءة الملف النصي وتحميله في صندوق النص
                Dim MyFileStream As New FileStream(FilePath, FileMode.Open)
                RichTextBox1.LoadFile(MyFileStream, _
                RichTextBoxStreamType.PlainText)
                MyFileStream.Close()
                'تحديد النصوص للطباعة
                StringToPrint = RichTextBox1.Text
                'تفعيل الزر طباعة
                btnPrint.Enabled = True
            Catch ex As Exception
                'عرض رسالة الخطأ إذا حدث خطأ
                MessageBox.Show(ex.Message)
            End Try
        End If
    End Sub

    Private Sub btnPrint_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnPrint.Click
        Try
            'حدد خيارات الصفحة الحالية
            PrintDocument1.DefaultPageSettings = PrintPageSettings
            'قم بتحديد النص المراد طباعته وقم بإظهار خيارات الطباعة 
            StringToPrint = RichTextBox1.Text
            PrintDialog1.Document = PrintDocument1
            Dim result As DialogResult = PrintDialog1.ShowDialog()
            'إذا ضغط المستخدم على نعم أو Ok قم بطباعة الصفحة
            If result = DialogResult.OK Then
                PrintDocument1.Print()
            End If
        Catch ex As Exception
            'لعرض رسالة خطأ إذا حدث
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    Private Sub PrintDocument1_PrintPage(ByVal sender As System.Object, ByVal e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        Dim numChars As Integer
        Dim numLines As Integer
        Dim stringForPage As String
        Dim strFormat As New StringFormat
        'بالإعتماد على إعدادات الصفحة، قم بتحديد مستطيل وهمي على الصفحة
        Dim rectDraw As New RectangleF( _
        e.MarginBounds.Left, e.MarginBounds.Top, _
        e.MarginBounds.Width, e.MarginBounds.Height)
        'قم بتعريف مساحة لتحديد كمية النصوص اللازم طباعتها على الصفحة الواحدة 
        'قم بإعتماد طول الصفحة ناقصاً سطر واحد حتى نطبع النص بصورة صحيحة
        Dim sizeMeasure As New SizeF(e.MarginBounds.Width, _
        e.MarginBounds.Height - PrintFont.GetHeight(e.Graphics))
        'عند طباعة النصوص الطويلة، فارق بين الكلمات 
        strFormat.Trimming = StringTrimming.Word
        'Compute how many chars and lines can fit based on sizeMeasure
        ' قم بحساب كم عدد الأسطر والحروف بالإعتماد على المقاسات
        e.Graphics.MeasureString(StringToPrint, PrintFont, _
        sizeMeasure, strFormat, numChars, numLines)
        'قم بحساب عدد الحروف التي تملئ الصفحة الواحدة
        stringForPage = StringToPrint.Substring(0, numChars)
        'قم بطباعة النص على الصفحة الحالية
        e.Graphics.DrawString(stringForPage, PrintFont, _
        Brushes.Black, rectDraw, strFormat)
        'إذا كان هناك نص إضافي قم بالتوضيح بأن هناك صفحات إضافية
        If numChars < StringToPrint.Length Then
            'قم بطرح النص المطبوع من بقية النص
            StringToPrint = StringToPrint.Substring(numChars)
            e.HasMorePages = True
        Else
            e.HasMorePages = False
            'All text has been printed, so restore string
            ' بعد طباعة النص كاملاً، قم بإعدادة النص إلى صندوق النص
            StringToPrint = RichTextBox1.Text
        End If
    End Sub
End Class
